// lib/services/userService.js

import { API_BASE_URL } from "@/util/BaseUrl";
import { getCurrentUser } from "./AuthService";

const USER_API_URL = API_BASE_URL+'/api/user/';

// Create/Register user
export const register = async (userData) => {
  const res = await fetch(`${USER_API_URL}create`, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(userData),
  });

  const data = await res.json();

  if (!res.ok) {
    throw new Error(data.message || "Something went wrong");
  }

  return data;
};

// Update self
export const updateProfile = async (updatedData) => {
  const user = getCurrentUser();
  const res = await fetch(`${USER_API_URL}self/update`, {
    method: "PUT",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${user.token}`,
    },
    body: JSON.stringify(updatedData),
  });

  const data = await res.json();
  if (!res.ok) {
    throw new Error(data.message || "Failed to update profile");
  }
  return data;
};

//self chnage password
export const changePassword = async (passwordData) => {
  const user = getCurrentUser();
  const res = await fetch(`${USER_API_URL}self/change-password`, {
    method: "PATCH",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${user.token}`,
    },
    body: JSON.stringify(passwordData),
  });

  const data = await res.json();
  if (!res.ok) {
    throw new Error(data.message || "Failed to update profile");
  }
  return data;
};

// Delete self
export const deleteAccount = async () => {
  const user = getCurrentUser();
  const res = await fetch(`${USER_API_URL}self/delete`, {
    method: "DELETE",
    headers: {
      Authorization: `Bearer ${user.token}`,
    },
  });

  const data = await res.json();
  if (!res.ok) {
    throw new Error(data.message || "Failed to update profile");
  }
  return data;
};
