import { API_BASE_URL } from "@/util/BaseUrl";
import { getCurrentUser } from "./AuthService";

const USER_PLAN_API_URL = API_BASE_URL+'/api/user-plan/';

// user plan renew requet
export const renewRequest = async (userPlanId) => {
  const user = getCurrentUser();
  const res = await fetch(`${USER_PLAN_API_URL}self/renew-request/${userPlanId}`, {
    method: "POST",
    headers: {
      Authorization: `Bearer ${user.token}`,
    },
  });

  const data = await res.json();

  if (!res.ok) {
    throw new Error(data.message || "Something went wrong");
  }

  return data;
};