import { API_BASE_URL } from "@/util/BaseUrl";

const PLAN_API_URL = API_BASE_URL+'/api/email/';

export const sendEmail = async (data) => {

  const res = await fetch(`${PLAN_API_URL}send`, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(data),
  });

  const response = await res.json();

  if (!res.ok) {
    throw new Error(response.message || "Something went wrong");
  }

  return response;

};