"use client";

import { IMAGE_BASE_URL } from "@/util/BaseUrl";
import Image from "next/image";
import { useState } from "react";

export default function ListingMediaViewer({ images, videos, title }) {
  const [currentIndex, setCurrentIndex] = useState(0);

  // Build carousel items: images first, then videos
  const imageItems =
    images && images.length > 0
      ? images.map((img) => ({
          type: "image",
          src: `${IMAGE_BASE_URL}/${img}`,
        }))
      : [{ type: "image", src: "/no-image.jpg" }];

  const videoItems =
    videos && videos.length > 0
      ? videos.map((url) => ({
          type: "video",
          src: url,
        }))
      : [];

  const items = [...imageItems, ...videoItems];
  const total = items.length;

  function getEmbedUrl(url) {
    try {
        const youtubeMatch = url.match(
        /(?:youtube\.com\/watch\?v=|youtu\.be\/)([a-zA-Z0-9_-]+)/
        );
        if (youtubeMatch) {
        return `https://www.youtube.com/embed/${youtubeMatch[1]}`;
        }

        const vimeoMatch = url.match(/vimeo\.com\/(\d+)/);
        if (vimeoMatch) {
        return `https://player.vimeo.com/video/${vimeoMatch[1]}`;
        }

        return url;
    } catch {
        return url;
    }
  }

  return (
    <div className="w-full flex flex-col items-center">
      {/* Unified Carousel (images + videos) */}
      <div className="relative w-full h-96 mb-6 rounded-lg overflow-hidden shadow">
        {items[currentIndex].type === "image" ? (
          <Image
            src={items[currentIndex].src}
            alt={title}
            fill
            className="object-cover"
            sizes="100vw"
          />
        ) : (
          <iframe
            src={getEmbedUrl(items[currentIndex].src)}
            title={`Video ${currentIndex + 1}`}
            className="w-full h-full"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowFullScreen
          ></iframe>
        )}

        {/* Prev / Next Buttons */}
        {total > 1 && (
          <>
            <button
              onClick={() =>
                setCurrentIndex((prev) => (prev === 0 ? total - 1 : prev - 1))
              }
              className="absolute left-2 top-1/2 -translate-y-1/2 bg-white/70 p-2 rounded-full shadow"
            >
              ◀
            </button>

            <button
              onClick={() =>
                setCurrentIndex((prev) => (prev === total - 1 ? 0 : prev + 1))
              }
              className="absolute right-2 top-1/2 -translate-y-1/2 bg-white/70 p-2 rounded-full shadow"
            >
              ▶
            </button>

            {/* Counter */}
            <div className="absolute bottom-2 right-2 bg-black/70 text-white text-xs px-2 py-1 rounded-md">
              {currentIndex + 1} / {total}
            </div>
          </>
        )}
      </div>
    </div>
  );
}