"use client";

import React, { useState, useEffect } from "react";
import Swal from "sweetalert2";
import { useRouter } from "next/navigation";
import { getMetaData, createListing } from "@/service/ListingService";
import ListingForm from "@/components/forms/ListingForm";

export default function SellPage() {
  const router = useRouter();
  const [meta, setMeta] = useState({});

  useEffect(() => {
    getMetaData().then(setMeta);
  }, []);

  const handleSubmit = async (formData) => {
    try {      
      await createListing(formData);
      localStorage.removeItem("pendingListing"); // clear only on success
      Swal.fire({
        icon: "success",
        title: "Listing created!",
        toast: true,
        position: "top-end",
        showConfirmButton: false,
        timer: 2000,
        timerProgressBar: true,
      });
      router.push("/user/listing");
    } catch (error) {
      Swal.fire({
        icon: "error",
        title: "Failed to create listing",
        text: error.message || "Something went wrong!",
      });
    }
  };

  return (
    <div className="max-w-4xl mx-auto py-10 px-4">
      <h1 className="text-3xl text-primary font-bold">Sell Your Truck</h1>
      <p className="text-xl mb-6 text-gray-600">Get the best value for your commercial vehicle with our trusted platform.</p>
        <ListingForm meta={meta} onSubmit={handleSubmit}/>
    </div>
  );
}
