import Hero from "@/components/hero"
import ListingCard from "@/components/listing/listingCard";
import StateLinks from "@/components/stateLinks";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { getAllBlogs } from "@/service/BlogService";
import { searchListing } from "@/service/ListingService";
import { COMPANY_NAME } from "@/util/constant";
import { Shield, Handshake, DollarSign, Headphones, ArrowRight} from "lucide-react";
import Image from "next/image";
import Link from "next/link";

export default async function Home() {

    const data = await getAllBlogs(0, 3);
    const blogPosts = data?.content || [];

    const listing = await searchListing({});
    const featuredTrucks = listing?.content || [];

    const features = [
    {
      icon: Shield,
      title: "Verified Listings",
      description: "Every vehicle is inspected and verified before listing",
      color: "bg-primary"
    },
    {
      icon: Handshake,
      title: "Trusted Network",
      description: "Connect with verified dealers and private sellers",
      color: "bg-chart-5"
    },
    {
      icon: DollarSign,
      title: "Best Prices",
      description: "Competitive pricing with financing options available",
      color: "bg-primary"
    },
    {
      icon: Headphones,
      title: "Expert Support",
      description: "Dedicated team to assist throughout your transaction",
      color: "bg-chart-5"
    }
  ];

  return (
    // <main className="flex flex-col items-center justify-center h-screen text-center px-4">
    <main className="min-h-screen">
      <Hero />
      
      {/* Featured Trucks Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl lg:text-4xl font-bold text-gray-900 mb-4">Featured Trucks</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">Discover our handpicked selection of premium commercial vehicles</p>
          </div>
          
          {!featuredTrucks || featuredTrucks.length === 0 ? (
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              {[...Array(3)].map((_, i) => (
                <Card key={i} className="animate-pulse">
                  <div className="h-64 bg-gray-300 rounded-t-xl"></div>
                  <CardContent className="p-6">
                    <div className="h-6 bg-gray-300 rounded mb-3"></div>
                    <div className="h-4 bg-gray-300 rounded mb-4"></div>
                    <div className="grid grid-cols-2 gap-4 mb-4">
                      <div className="h-4 bg-gray-300 rounded"></div>
                      <div className="h-4 bg-gray-300 rounded"></div>
                      <div className="h-4 bg-gray-300 rounded"></div>
                      <div className="h-4 bg-gray-300 rounded"></div>
                    </div>
                    <div className="flex justify-between items-center">
                      <div className="h-8 bg-gray-300 rounded w-24"></div>
                      <div className="h-10 bg-gray-300 rounded w-32"></div>
                    </div>
                  </CardContent>
                </Card>
              ))}
            </div>
          ) : (
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              {featuredTrucks?.slice(0, 3).map((truck) => (
                <ListingCard key={truck.id} listing={truck} />
              ))}
            </div>
          )}

          <div className="text-center mt-12">
            <Link href="/find-trucks">
              <Button size="lg" className="bg-primary hover:bg-primary/80">
                View All Inventory <ArrowRight className="ml-2 h-5 w-5" />
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* Why Choose Us Section */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl lg:text-4xl font-bold text-gray-900 mb-4">Why Choose {COMPANY_NAME}?</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">We're the trusted partner for commercial vehicle transactions</p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {features.map((feature, index) => {
              const Icon = feature.icon;
              return (
                <div key={index} className="text-center">
                  <div className={`${feature.color} text-white w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4`}>
                    <Icon className="h-8 w-8" />
                  </div>
                  <h3 className="text-xl font-bold text-gray-900 mb-2">{feature.title}</h3>
                  <p className="text-muted-foreground">{feature.description}</p>
                </div>
              );
            })}
          </div>
        </div>
      </section>

      {/* Latest Blog Posts */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl lg:text-4xl font-bold text-gray-900 mb-4">Latest News & Insights</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">Stay updated with industry trends, maintenance tips, and market insights</p>
          </div>

          {!blogPosts || blogPosts.length === 0 ? (
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              {[...Array(3)].map((_, i) => (
                <Card key={i} className="animate-pulse">
                  <div className="h-48 bg-gray-300 rounded-t-xl"></div>
                  <CardContent className="p-6">
                    <div className="h-4 bg-gray-300 rounded mb-2 w-24"></div>
                    <div className="h-6 bg-gray-300 rounded mb-3"></div>
                    <div className="h-4 bg-gray-300 rounded mb-4"></div>
                    <div className="h-4 bg-gray-300 rounded w-20"></div>
                  </CardContent>
                </Card>
              ))}
            </div>
          ) : (
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
              {blogPosts?.map((post) => (
                <article key={post.id} className="bg-white rounded-xl shadow-lg overflow-hidden border border-gray-200">
                  <div className="relative w-full h-48">
                    <Image
                      src={post.coverImageUrl}
                      alt={post.title}
                      priority
                      fill
                      className="object-cover rounded-t-md"
                    />
                  </div>
                  <div className="p-6">
                    <div className="text-sm text-muted-foreground mb-2">
                      {new Date(post.publishedDate).toLocaleDateString('en-US', { 
                        year: 'numeric', 
                        month: 'long', 
                        day: 'numeric' 
                      })}
                    </div>
                    <h3 className="text-xl font-bold text-gray-900 mb-3 line-clamp-2">{post.title}</h3>
                    <p className="text-muted-foreground mb-4 line-clamp-2">{post.content.replace(/<[^>]+>/g, "").slice(0, 100)}...</p>
                    <a href={`/blogs/${post.formattedTitle}`} className="text-primary font-semibold hover:text-chart-5 transition-colors">
                      Read More <ArrowRight className="inline ml-1 h-4 w-4" />
                    </a>
                  </div>
                </article>
              ))}
            </div>
          )}

          <div className="text-center mt-12">
            <Link href="/blogs">
              <Button size="lg" className="bg-primary hover:bg-primary/80">
                View All Articles <ArrowRight className="ml-2 h-5 w-5" />
              </Button>
            </Link>
          </div>
        </div>
      </section>
      
      <StateLinks />
    </main>
  )
}
