import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import Navbar from "./common/navbar";
import Footer from "./common/footer";
import { AuthProvider } from "./context/AuthContext";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata = {
  title: "Truck Trailer Deals",
  description: "Connect buyers and sellers of truck trailers easily.",
  icons: {
    icon: "/ttd-logo.svg", // can also be .png or .svg
    shortcut: "/ttd-logo.svg",
    apple: "/ttd-logo.svg",
  },
};

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased`}
      >
        <AuthProvider>
          <Navbar />
          {children}
          <Footer />
        </AuthProvider>
      </body>
    </html>
  );
}
