// app/find-trucks/page.jsx
import ListingCard from "@/components/listing/ListingCard";
import { searchListing } from "@/service/ListingService";
import SearchBar from "@/components/listing/SearchBar";
import Filters from "@/components/listing/Filters";
import Pagination from "../common/pagination";
import FindTrucksClient from "./FindTruckClient";

export default async function FindTrucksPage({ searchParams }) {
    const {
        page = "0",
        size = "9",
        type = "",
        condition = "",
        titleKeyword,
        city,
        state,
        country,
        minPrice,
        maxPrice,
        year,
        categoryId,
        makerId,
        modelId,
        trimId,
        truckClassId,
        fuelTypeId,
        transmission,
        transmissionSpeed,
        engineManufacturer,
        driverSide,
        mileageRange,
        trailerComposition,
        trailerFloorType,
        trailerHitch,
        trailerNumberOfAxles,
        trailerMinLength,
        trailerMaxLength,
        trailerMinWidth,
        trailerMaxWidth,
        trailerMinHeight,
        trailerMaxHeight,
        // lat,
        // lng,
    } = await searchParams || {}; // fallback for undefined

    const searchRequest = {
        page: parseInt(page),
        size: parseInt(size),
        type: type || undefined,
        condition : condition || undefined,
        titleKeyword,
        city,
        state,
        country,
        minPrice: minPrice ? parseFloat(minPrice) : undefined,
        maxPrice: maxPrice ? parseFloat(maxPrice) : undefined,
        year,
        categoryId,
        makerId,
        modelId,
        trimId,
        truckClassId,
        fuelTypeId,
        transmission,
        transmissionSpeed,
        engineManufacturer,
        driverSide,
        mileageRange,
        trailerComposition,
        trailerFloorType,
        trailerHitch,
        trailerNumberOfAxles,
        trailerMinLength,
        trailerMaxLength,
        trailerMinWidth,
        trailerMaxWidth,
        trailerMinHeight,
        trailerMaxHeight,
        // lat,
        // lng,
    };

    let listings = [];
    let currentPage = 0;
    let totalPages = 0;

    // try {
        const response = await searchListing(searchRequest);
        listings = response.content || [];
        currentPage = response.currentPage;
        totalPages = response.totalPages;
    // } catch (error) {
    //     console.error("Error fetching listings:", error.message);
    // }

    return (
        <FindTrucksClient listings={response} searchParams={searchParams}/>
        // <main className="min-h-screen bg-gray-100">
        //     {/* Header with shared background */}
        //     <div className="bg-white border-b border-gray-200 px-4 py-6">
        //         <div className="max-w-7xl mx-auto flex flex-col md:flex-row items-start md:items-center justify-between gap-4">
        //             <div>
        //                 <h1 className="text-2xl font-bold text-primary">Find Trucks & Trailers</h1>
        //                 <p className="text-sm text-gray-500 mt-1">Your next heavy-duty partner is just a search away.</p>
        //             </div>
        //             <SearchBar />
        //         </div>
        //     </div>

        //     {/* Main layout with sidebar and content */}
        //     <div className="max-w-7xl grid grid-cols-1 md:grid-cols-[320px_1fr] gap-x-8">
        //         {/* Sidebar Filters with unified background */}
        //         <aside className="bg-white border border-gray-200 p-4 min-h-screen ">
        //             <Filters />
        //         </aside>

        //         {/* Main listing grid and pagination */}
        //         <section className="mx-auto gap-6 px-4 py-6">
        //             <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
        //                 {listings.length === 0 ? (
        //                     <div className="col-span-full text-center text-gray-600 py-10">
        //                         No listings found. Try adjusting your filters.
        //                     </div>
        //                 ) : (
        //                     listings.map((listing) => (
        //                         <ListingCard key={listing.id} listing={listing} />
        //                     ))
        //                 )}
        //             </div>

        //             {totalPages > 1 && (
        //                 <Pagination
        //                     currentPage={currentPage}
        //                     totalPages={totalPages}
        //                     basePath="/find-trucks"
        //                 />
        //             )}
        //         </section>
        //     </div>
        // </main>

    );
}
