"use client";

import { useState, useEffect } from "react";
import Filters from "@/components/listing/Filters";
import SearchBar from "@/components/listing/SearchBar";
import ListingCard from "@/components/listing/ListingCard";
import Pagination from "@/app/common/pagination";
import { Gauge, Truck } from "lucide-react";

export default function FindTrucksClient({ listings }) {
  const [loading, setLoading] = useState(false);
  const [data, setData] = useState(listings);

  // when new server data comes (on route change), turn off loader
  useEffect(() => {
    setData(listings);
    setLoading(false);
  }, [listings]);

  return (
    <main className="min-h-screen bg-gray-100">
      <div className="bg-white border-b border-gray-200 px-4 py-6">
        <div className="max-w-7xl mx-auto flex flex-col md:flex-row items-start md:items-center justify-between gap-4">
          <div>
            <h1 className="text-2xl font-bold text-primary">Find Trucks & Trailers</h1>
            <p className="text-sm text-gray-500 mt-1">Your next heavy-duty partner is just a search away.</p>
          </div>
          {/* <SearchBar setLoading={setLoading} /> */}
        </div>
      </div>

      <div className="max-w-7xl grid grid-cols-1 md:grid-cols-[320px_1fr] gap-x-8">
        <aside className="bg-white border border-gray-200 p-4 min-h-screen">
          <Filters setLoading={setLoading} />
        </aside>

        <section className="mx-auto gap-6 px-4 py-6">
          {loading ? (    
            <div className="flex justify-center items-center min-h-[60vh]">
                <div className="relative w-16 h-16">
                <div className="absolute inset-0 rounded-full border-8 border-gray-300"></div>
                <div className="absolute inset-0 rounded-full border-8   border-primary border-t-transparent animate-spin"></div>
                </div>
            </div>
          ) : (
            <>
              <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
                {data.content?.length === 0 ? (
                  <div className="col-span-full text-center text-gray-600 py-10">
                    No listings found. Try adjusting your filters.
                  </div>
                ) : (
                  data.content.map((listing) => (
                    <ListingCard key={listing.id} listing={listing} />
                  ))
                )}
              </div>

              {data.totalPages > 1 && (
                <Pagination
                  currentPage={data.currentPage}
                  totalPages={data.totalPages}
                  basePath="/find-trucks"
                />
              )}
            </>
          )}
        </section>
      </div>
    </main>
  );
}
