"use client";

import { Phone, Mail, MapPin, Send } from "lucide-react";
import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Label } from "@/components/ui/label";
import { ADDRESS, COMPANY_NAME, SUPPORT_EMAIL, SUPPORT_PHONE } from "@/util/constant";

export default function Contact() {
  const contactMethods = [
    {
      icon: Phone,
      title: "Phone Support",
      description: "Speak with our sales team",
      value: SUPPORT_PHONE,
      additional: "Mon-Fri 8AM-8PM, Sat 9AM-5PM",
      color: "bg-primary"
    },
    {
      icon: Mail,
      title: "Email Support",
      description: "Get detailed assistance",
      value: SUPPORT_EMAIL,
      additional: "Response within 24 hours",
      color: "bg-chart-5"
    },
    {
      icon: MapPin,
      title: "Visit Our Showroom",
      description: "See trucks in person",
      value: ADDRESS,
      additional: "Commerce City, TX 75001",
      color: "bg-primary"
    }
  ];

  return (
    <div className="min-h-screen bg-gray-50 py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Heading */}
        <div className="text-center mb-12">
          <h1 className="text-3xl lg:text-4xl font-bold text-gray-900 mb-4">Get In Touch</h1>
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            Have questions? Our expert team is here to help you find the perfect commercial vehicle.
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12">
          {/* Left Column - Contact Methods */}
          <div className="space-y-8">
            {contactMethods.map((method, index) => {
              const Icon = method.icon;
              return (
                <div key={index} className="flex items-start">
                  <div className={`${method.color} text-white w-12 h-12 rounded-full flex items-center justify-center mr-4`}>
                    <Icon className="w-6 h-6" />
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold mb-1">{method.title}</h3>
                    <p className="text-muted-foreground mb-1">{method.description}</p>
                    <p className="text-primary font-semibold">{method.value}</p>
                    <p className="text-sm text-muted-foreground">{method.additional}</p>
                  </div>
                </div>
              );
            })}

            <Card className="mt-12">
              <CardContent className="p-6">
                <h3 className="text-lg font-semibold mb-4">Why Contact {COMPANY_NAME}?</h3>
                <ul className="space-y-2 text-sm text-muted-foreground">
                  <li>• Expert guidance on commercial vehicle selection</li>
                  <li>• Financing options and payment assistance</li>
                  <li>• Vehicle history reports and inspections</li>
                  <li>• Trade-in valuations and assessments</li>
                  <li>• Fleet management consultation</li>
                </ul>
              </CardContent>
            </Card>
          </div>

          {/* Right Column - Static Form */}
          <div>
          <Card className="shadow-lg">
            <CardContent className="p-8 space-y-6">
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div >
                  <Label className="mb-2">First Name *</Label>
                  <Input placeholder="John"/>
                </div>
                <div>
                  <Label className="mb-2">Last Name *</Label>
                  <Input placeholder="Smith" />
                </div>
              </div>

              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                  <Label className="mb-2">Email *</Label>
                  <Input type="email" placeholder="john@example.com" />
                </div>
                <div>
                  <Label className="mb-2">Phone *</Label>
                  <Input type="tel" placeholder="(555) 123-4567" />
                </div>
              </div>

              <div>
                <Label className="mb-2">Subject *</Label>
                <select className="w-full border border-input rounded px-3 py-2">
                  <option value="">Select a subject</option>
                  <option value="General Inquiry">General Inquiry</option>
                  <option value="Buying a Truck">Buying a Truck</option>
                  <option value="Selling a Truck">Selling a Truck</option>
                  <option value="Financing Questions">Financing Questions</option>
                  <option value="Technical Support">Technical Support</option>
                  <option value="Partnership Inquiry">Partnership Inquiry</option>
                </select>
              </div>

              <div>
                <Label className="mb-2">Message *</Label>
                <Textarea rows={4} placeholder="Tell us how we can help you..." />
              </div>

              <Button size="lg" className="w-full">
                Send Message <Send className="ml-2 w-4 h-4" />
              </Button>
            </CardContent>
          </Card>
            {/* Response Time Notice */}
            <div className="mt-6 p-4 bg-blue-50 rounded-lg">
              <p className="text-sm">
                <strong>Response Time:</strong> We typically respond to all inquiries within 24 hours during business days. 
                For urgent matters, please call us directly at {SUPPORT_PHONE}.
              </p>
            </div>
            </div>
        </div>

        {/* Map + Hours */}
        <Card className="mt-16 py-0 gap-0">
          <CardContent className="p-0">
            <div className="bg-gray-200 h-64 flex flex-col items-center justify-center rounded-t-xl">
              <MapPin className="w-12 h-12 text-gray-500 mb-2" />
              <p className="text-gray-700">123 Truck Plaza Drive, Commerce City, TX 75001</p>
              <p className="text-sm text-gray-500">Interactive Map Placeholder</p>
            </div>
            <div className="p-6 bg-white rounded-b-xl grid grid-cols-1 md:grid-cols-3 gap-6 text-center">
              <div>
                <h4 className="font-semibold mb-1">Showroom Hours</h4>
                <p className="text-sm text-muted-foreground">
                  Mon-Fri: 8:00 AM - 8:00 PM<br />
                  Saturday: 9:00 AM - 5:00 PM<br />
                  Sunday: Closed
                </p>
              </div>
              <div>
                <h4 className="font-semibold mb-1">Service Hours</h4>
                <p className="text-sm text-muted-foreground">
                  Mon-Fri: 7:00 AM - 6:00 PM<br />
                  Saturday: 8:00 AM - 4:00 PM<br />
                  Sunday: Emergency Only
                </p>
              </div>
              <div>
                <h4 className="font-semibold mb-1">Parts Department</h4>
                <p className="text-sm text-muted-foreground">
                  Mon-Fri: 7:00 AM - 5:00 PM<br />
                  Saturday: 8:00 AM - 3:00 PM<br />
                  Sunday: Closed
                </p>
              </div>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  );
}
