// "use client";
// import { Button } from "@/components/ui/button";
// import { ChevronLeft, ChevronRight } from "lucide-react";
// import Link from "next/link";

// export default function Pagination({ currentPage, totalPages, basePath }) {
//   const createPageLink = (page) => `${basePath}?page=${page}`;

//   if (totalPages <= 1) return null;

//   const pagesToShow = 5;
//   const start = Math.max(0, currentPage - Math.floor(pagesToShow / 2));
//   const end = Math.min(start + pagesToShow - 1, totalPages - 1);

//   const pageNumbers = [];
//   for (let i = start; i <= end; i++) {
//     pageNumbers.push(i);
//   }

//   return (
//     <div className="flex items-center justify-center gap-2 mt-10">
//         {currentPage > 0 ? (
//         <Link href={createPageLink(currentPage - 1)}>
//             <Button variant="outline" size="sm">
//             <ChevronLeft className="w-4 h-4" />
//             </Button>
//         </Link>
//         ) : (
//         <Button variant="outline" size="sm" disabled>
//             <ChevronLeft className="w-4 h-4" />
//         </Button>
//         )}

//       {pageNumbers.map((page) => (
//         <Link key={page} href={createPageLink(page)} passHref>
//           <Button
//             variant={page === currentPage ? "default" : "outline"}
//             size="sm"
//           >
//             {page + 1}
//           </Button>
//         </Link>
//       ))}

//         {currentPage < totalPages - 1 ? (
//         <Link href={createPageLink(currentPage + 1)}>
//             <Button variant="outline" size="sm">
//             <ChevronRight className="w-4 h-4" />
//             </Button>
//         </Link>
//         ) : (
//         <Button variant="outline" size="sm" disabled>
//             <ChevronRight className="w-4 h-4" />
//         </Button>
//         )}
//     </div>
//   );
// }

"use client";

import { Button } from "@/components/ui/button";
import { ChevronLeft, ChevronRight } from "lucide-react";
import Link from "next/link";

export default function Pagination({ currentPage, totalPages, basePath, onPageChange }) {
  if (totalPages <= 1) return null;

  const pagesToShow = 5;
  const start = Math.max(0, currentPage - Math.floor(pagesToShow / 2));
  const end = Math.min(start + pagesToShow - 1, totalPages - 1);

  const pageNumbers = [];
  for (let i = start; i <= end; i++) {
    pageNumbers.push(i);
  }

  const goToPage = (page) => {
    if (onPageChange) {
      onPageChange(page);
    }
  };

  const renderButton = (page, label = null) => {
    const content = (
      <Button
        variant={page === currentPage ? "default" : "outline"}
        size="sm"
        onClick={() => goToPage(page)}
      >
        {label || page + 1}
      </Button>
    );

    return basePath && !onPageChange ? (
      <Link key={page} href={`${basePath}?page=${page}`}>
        {content}
      </Link>
    ) : (
      <span key={page}>{content}</span>
    );
  };

  return (
    <div className="flex items-center justify-center gap-2 mt-10">
      {/* Previous */}
      {currentPage > 0 ? (
        basePath && !onPageChange ? (
          <Link href={`${basePath}?page=${currentPage - 1}`}>
            <Button variant="outline" size="sm">
              <ChevronLeft className="w-4 h-4" />
            </Button>
          </Link>
        ) : (
          <Button
            variant="outline"
            size="sm"
            onClick={() => goToPage(currentPage - 1)}
          >
            <ChevronLeft className="w-4 h-4" />
          </Button>
        )
      ) : (
        <Button variant="outline" size="sm" disabled>
          <ChevronLeft className="w-4 h-4" />
        </Button>
      )}

      {/* Pages */}
      {pageNumbers.map((page) => renderButton(page))}

      {/* Next */}
      {currentPage < totalPages - 1 ? (
        basePath && !onPageChange ? (
          <Link href={`${basePath}?page=${currentPage + 1}`}>
            <Button variant="outline" size="sm">
              <ChevronRight className="w-4 h-4" />
            </Button>
          </Link>
        ) : (
          <Button
            variant="outline"
            size="sm"
            onClick={() => goToPage(currentPage + 1)}
          >
            <ChevronRight className="w-4 h-4" />
          </Button>
        )
      ) : (
        <Button variant="outline" size="sm" disabled>
          <ChevronRight className="w-4 h-4" />
        </Button>
      )}
    </div>
  );
}
