'use client'

import Link from "next/link"
import { usePathname } from "next/navigation"
import { Menu, User, LogOut, LogIn, Package } from "lucide-react"
import { Sheet, SheetTrigger, SheetContent, SheetHeader, SheetTitle  } from "@/components/ui/sheet"
import { Button } from "@/components/ui/button"
import { COMPANY_NAME } from "@/util/constant"
import { useContext } from "react"
import {
  DropdownMenu,
  DropdownMenuTrigger,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuSeparator
} from "@/components/ui/dropdown-menu"
import AuthContext from "@/app/context/AuthContext"
import {
  Home,
  Truck,
  Upload,
  BookText,
  Info,
  Mail,
} from "lucide-react";

const links = [
  { href: "/", label: "Home", icon: Home },
  { href: "/find-trucks", label: "Find Trucks", icon: Truck },
  { href: "/sell", label: "Sell My Truck", icon: Upload },
  { href: "/blogs", label: "Blogs", icon: BookText },
  { href: "/plans", label: "Plans", icon: Package },
  { href: "/about", label: "About", icon: Info },
  { href: "/contact", label: "Contact", icon: Mail },
];

export default function Navbar() {
  const pathname = usePathname()
  const { isLoggedIn, logout } = useContext(AuthContext)

  const isActive = (href) => pathname === href

  return (
    <header className="w-full border-b bg-background sticky top-0 z-50">
      <div className="flex items-center justify-between px-4 py-3 max-w-7xl mx-auto">
        <Link href="/" className="flex items-center space-x-2">
          <h1 className="text-2xl font-bold text-primary">{COMPANY_NAME}</h1>
        </Link>

        {/* Desktop Nav */}
        <nav className="hidden md:flex gap-4 items-center">
          {links.map((link) => (
            <Link
              key={link.href}
              href={link.href}
              className={`flex items-center gap-2 text-sm font-medium px-3 py-2 rounded-md transition ${
                isActive(link.href)
                  ? "bg-primary text-primary-foreground"
                  : "text-muted-foreground hover:bg-muted hover:text-foreground"
              }`}
            >
              
              <link.icon className="w-4 h-4" />
              {link.label}
            </Link>
          ))}

          {!isLoggedIn() ? (
            <Link
              href="/signin"
              className={`flex items-center gap-2 text-sm font-medium px-3 py-2 rounded-md transition ${
                isActive("/signin")
                  ? "bg-primary text-primary-foreground"
                  : "text-muted-foreground hover:bg-muted hover:text-foreground"
              }`}
            >
              <LogIn className="w-4 h-4" />
              Sign In
            </Link>
          ) : (
            <DropdownMenu>
              <DropdownMenuTrigger asChild>
                <Button variant="ghost" className="ml-2 flex items-center gap-1">
                  <User className="h-5 w-5" />
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    className="h-4 w-4"
                    fill="none"
                    viewBox="0 0 24 24"
                    stroke="currentColor"
                  >
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M19 9l-7 7-7-7" />
                  </svg>
                </Button>
              </DropdownMenuTrigger>
              <DropdownMenuContent align="end">
                <DropdownMenuItem asChild>
                  <Link href="/user/profile">Profile</Link>
                </DropdownMenuItem>
                <DropdownMenuItem asChild>
                  <Link href="/user/listing">My Listings</Link>
                </DropdownMenuItem>
                <DropdownMenuItem asChild>
                  <Link href="/user/change-password">Change Password</Link>
                </DropdownMenuItem>
                <DropdownMenuSeparator />
                <DropdownMenuItem
                  onClick={logout}
                  className="flex items-center gap-2 text-red-600 cursor-pointer"
                >
                  <LogOut className="h-4 w-4" /> Log Out
                </DropdownMenuItem>
              </DropdownMenuContent>
            </DropdownMenu>
          )}
        </nav>

        {/* Mobile Nav */}
        <div className="md:hidden">
          <Sheet>
            <SheetTrigger asChild>
              <Button variant="outline" size="icon">
                <Menu className="h-5 w-5" />
              </Button>
            </SheetTrigger>
            <SheetContent side="left">
            <SheetHeader>
              <SheetTitle>Menu</SheetTitle>
            </SheetHeader>
              <nav className="flex flex-col gap-2 mt-4">
                {links.map((link) => (
                  <Link
                    key={link.href}
                    href={link.href}
                    className={`flex items-center gap-2 text-sm font-medium px-3 py-2 rounded-md transition ${
                      isActive(link.href)
                        ? "bg-primary text-primary-foreground"
                        : "text-muted-foreground hover:bg-muted hover:text-foreground"
                    }`}
                  >
                    
                    <link.icon className="w-4 h-4" />
                    {link.label}
                  </Link>
                ))}

                {!isLoggedIn() ? (
                  <Link
                    href="/signin"
                    className={`flex items-center gap-2 text-sm font-medium px-3 py-2 rounded-md transition ${
                      isActive("/signin")
                        ? "bg-primary text-primary-foreground"
                        : "text-muted-foreground hover:bg-muted hover:text-foreground"
                    }`}
                  >
                    <LogIn className="w-4 h-4" />
                    Sign In
                  </Link>
                ) : (
                  <div className="flex flex-col gap-2">
                    <Link
                      href="/user/profile"
                      className="text-sm font-medium px-3 py-2 rounded-md hover:bg-muted"
                    >
                      Profile
                    </Link>
                    <Link
                      href="/user/listing"
                      className="text-sm font-medium px-3 py-2 rounded-md hover:bg-muted"
                    >
                      My Listings
                    </Link>
                    <Link
                      href="/user/change-password"
                      className="text-sm font-medium px-3 py-2 rounded-md hover:bg-muted"
                    >
                      Change Password
                    </Link>
                    <Button
                      onClick={logout}
                      variant="destructive"
                      className="w-full"
                    >
                      Log Out
                    </Button>
                  </div>
                )}
              </nav>
            </SheetContent>
          </Sheet>
        </div>
      </div>
    </header>
  )
}
