import Link from "next/link"
import { Facebook, Instagram, Twitter, Mail, Phone } from "lucide-react"
import {
  COMPANY_NAME,
  COPYRIGHT_YEAR,
  SUPPORT_EMAIL,
  SUPPORT_PHONE,
} from "@/util/constant"

export default function Footer() {
  return (
    <footer className="bg-neutral-950 text-neutral-300 border-t border-neutral-800">
      <div className="max-w-7xl mx-auto px-4 py-10 grid grid-cols-1 md:grid-cols-3 gap-8 text-sm">
        
        {/* Column 1: Logo & Description */}
        <div>
          <h2 className="text-lg font-semibold text-white mb-2">{COMPANY_NAME}</h2>
          <p className="text-muted-foreground">
            Your trusted marketplace for buying and selling trucks nationwide.
          </p>
        </div>

        {/* Column 2: Navigation Links */}
        <div>
          <h3 className="text-md font-medium text-white mb-2">Quick Links</h3>
          <ul className="space-y-1 text-muted-foreground">
            <li><Link href="/" className="hover:underline">Home</Link></li>
            <li><Link href="/browse" className="hover:underline">Browse Trucks</Link></li>
            <li><Link href="/sell" className="hover:underline">Sell My Truck</Link></li>
            <li><Link href="/blogs" className="hover:underline">Blogs</Link></li>
            <li><Link href="/contact" className="hover:underline">Contact</Link></li>
          </ul>
        </div>

        {/* Column 3: Contact & Social */}
        <div>
          <h3 className="text-md font-medium text-white mb-2">Get in Touch</h3>
          <ul className="space-y-2 text-muted-foreground">
            <li className="flex items-center gap-2">
              <Mail className="h-4 w-4" />
              <a href={`mailto:${SUPPORT_EMAIL}`} className="hover:underline">
                {SUPPORT_EMAIL}
              </a>
            </li>
            <li className="flex items-center gap-2">
              <Phone className="h-4 w-4" />
              <a href={`tel:${SUPPORT_PHONE}`} className="hover:underline">
                {SUPPORT_PHONE}
              </a>
            </li>
            <li className="flex gap-4 mt-4">
              <a href="#" aria-label="Twitter"><Twitter className="h-5 w-5 hover:text-white" /></a>
              <a href="#" aria-label="Facebook"><Facebook className="h-5 w-5 hover:text-white" /></a>
              <a href="#" aria-label="Instagram"><Instagram className="h-5 w-5 hover:text-white" /></a>
            </li>
          </ul>
        </div>
      </div>

      <div className="border-t border-neutral-800 text-center text-xs py-4 text-muted-foreground">
        &copy; {COPYRIGHT_YEAR} {COMPANY_NAME}. All rights reserved.
      </div>
    </footer>
  )
}