// Blog List Page (app/blogs/page.jsx)
import Link from "next/link";
import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import Image from "next/image";
import { getAllBlogs } from "@/service/BlogService";
import Pagination from "../common/pagination";

export const metadata = {
  title: "Truck Trailer Deals - Blogs",
  description: "Explore insights and tips on truck trailer driving.",
  keywords: "truck trailer blog, truck drivers, CDL tips, trucking advice",
  alternates: { canonical: "/blogs" },
  openGraph: {
    title: "Truck Trailer Deals Blog",
    description: "Tips, guides, and stories for truck drivers and trailer operators.",
    url: "/blogs",
    type: "website",
  },
};

export default async function BlogPage(props) {
  
  const searchParams = await props.searchParams;
  const page = parseInt(searchParams?.page || 0);  
  const size = 6;
  const data = await getAllBlogs(page, size);
  const blogs = data?.content || [];
  const totalPages = data?.totalPages || 1;

  return (
    <section className="max-w-7xl mx-auto px-4 py-10">
      <h1 className="text-3xl font-bold text-center mb-8">All Blogs</h1>
      <div className="grid gap-8 sm:grid-cols-2 lg:grid-cols-3">
        {blogs.map((blog) => (
          <Card key={blog.id} className="overflow-hidden py-0 gap-0">
            <div className="relative w-full h-48">
              <Image
                src={blog.coverImageUrl}
                alt={blog.title}
                priority
                fill
                className="object-cover rounded-t-md"
              />
            </div>
            <CardContent className="p-4">
              <h2 className="text-lg font-semibold mb-2 line-clamp-2">{blog.title}</h2>
              <p className="text-sm text-muted-foreground mb-4 line-clamp-3">
                {blog.content.replace(/<[^>]+>/g, "").slice(0, 100)}...
              </p>
              <Link href={`/blogs/${blog.formattedTitle}`}>
                <Button variant="default" className="w-full">Read More</Button>
              </Link>
            </CardContent>
          </Card>
        ))}
      </div>

      <Pagination currentPage={page} totalPages={totalPages} basePath="/blogs" />
    </section>
  );
}
